package gov.va.med.mhv.rxrefill.util;

import gov.va.med.mhv.rxrefill.data.model.Request;
import gov.va.med.mhv.rxrefill.data.model.RequestAttempt;
import gov.va.med.mhv.rxrefill.enums.RequestFunctionEnumeration;
import gov.va.med.mhv.rxrefill.enums.RequestStatusEnumeration;

import org.springframework.stereotype.Component;

@Component
public final class RequestUtils {

	/*
	 * public final RequestStatusEnumeration FAILED_STATUS =
	 * RequestStatusEnumeration.getEnum(RequestStatusEnumeration.FAILED);
	 * 
	 * public final RequestStatusEnumeration REJECTED_STATUS =
	 * RequestStatusEnumeration.getEnum(RequestStatusEnumeration.REJECTED);
	 * 
	 * public final RequestStatusEnumeration SUCCESSFUL_STATUS =
	 * RequestStatusEnumeration.getEnum(RequestStatusEnumeration.SUCCESSFUL);
	 * 
	 * public final RequestStatusEnumeration INPROGRESS_STATUS =
	 * RequestStatusEnumeration.getEnum(RequestStatusEnumeration.INPROGRESS);
	 * 
	 * public final RequestFunctionEnumeration REFILL_FUNCTION =
	 * RequestFunctionEnumeration.getEnum(RequestFunctionEnumeration.REFILLPRESCRIPTION);
	 * 
	 * public final RequestFunctionEnumeration PROFILE_FUNCTION =
	 * RequestFunctionEnumeration.getEnum(RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE);
	 * 
	 * public final RequestFunctionEnumeration STATUS_FUNCTION =
	 * RequestFunctionEnumeration.getEnum(RequestFunctionEnumeration.GETPRESCRIPTIONSTATUS);
	 * 
	 * public final RequestFunctionEnumeration UPDATE_FUNCTION =
	 * RequestFunctionEnumeration.getEnum(RequestFunctionEnumeration.GETPRESCRIPTIONUPDATE);
	 */

	private RequestUtils() {
		// Hide constructor for utility class
	}

	public boolean isInProgress(Request request) {
		return (request != null)
				&& RequestStatusEnumeration.INPROGRESS.getDescription().equalsIgnoreCase(request.getStatus());
	}

	public boolean hasSucceeded(Request request) {
		return (request != null) && RequestStatusEnumeration.SUCCESSFUL.getDescription().equalsIgnoreCase(request.getStatus());
	}

	public boolean hasFailed(Request request) {
		return (request != null) && RequestStatusEnumeration.FAILED.getDescription().equalsIgnoreCase(request.getStatus());
	}

	public boolean hasBeenRejected(Request request) {
		return (request != null) && RequestStatusEnumeration.REJECTED.getDescription().equalsIgnoreCase(request.getStatus());
	}

	public boolean isRefillRequest(Request request) {
		return (request != null) && RequestFunctionEnumeration.REFILLPRESCRIPTION.getValue() == request.getRequestFunction();
	}

	public boolean isStatusRequest(Request request) {
		return (request != null) && RequestFunctionEnumeration.GETPRESCRIPTIONSTATUS.getValue() == request.getRequestFunction();
	}

	public boolean isProfileRequest(Request request) {
		return (request != null) && RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue() == request.getRequestFunction();
	}

	public boolean hasUpdateFunction(Request request) {
		return (request != null) && RequestFunctionEnumeration.GETPRESCRIPTIONUPDATE.getValue() == request.getRequestFunction();
	}

	public boolean isInProgress(RequestAttempt attempt) {
		return (attempt != null) && RequestStatusEnumeration.INPROGRESS.getDescription().equalsIgnoreCase(attempt.getStatus());
	}

	public boolean hasSucceeded(RequestAttempt attempt) {
		return (attempt != null) && hasSucceeded(attempt.getParentRequest());
	}

	public boolean hasFailed(RequestAttempt attempt) {
		return (attempt != null) && hasFailed(attempt.getParentRequest());
	}

	public boolean hasBeenRejected(RequestAttempt attempt) {
		return (attempt != null) && hasBeenRejected(attempt.getParentRequest());
	}

	public boolean isStatusRequest(RequestAttempt attempt) {
		return (attempt != null) && isStatusRequest(attempt.getParentRequest());
	}

	public boolean isProfileRequest(RequestAttempt attempt) {
		return (attempt != null) && isProfileRequest(attempt.getParentRequest());
	}

	public boolean hasUpdateFunction(RequestAttempt attempt) {
		return (attempt != null) && hasUpdateFunction(attempt.getParentRequest());
	}

	public boolean isRefillRequest(RequestAttempt attempt) {
		return (attempt != null) && isRefillRequest(attempt.getParentRequest());
	}
}
